package it.unicam.pizzeria4.util;

import java.util.Iterator;
import java.util.Vector;

public class DettagliTavolo {

	String idTavolo;
	String immagine;
	int capienza;
	boolean occupato;
	boolean composito;
	Vector<String> listaComponenti;

	public DettagliTavolo(String idTavolo, String immagine, int capienza, boolean occupato, boolean composito) {
		this.capienza = capienza;
		this.idTavolo = idTavolo;
		this.immagine = immagine;
		this.occupato = occupato;
		this.composito = composito;
		if (composito)
			listaComponenti = new Vector<String>();
	}

	public void addTavoloComponente(String idTavolo) {
		listaComponenti.add(idTavolo);
	}

	public boolean isOccupato() {
		return occupato;
	}

	public boolean isComposito() {
		return composito;
	}

	public String getIdTavolo() {
		return idTavolo;
	}

	public String getImmagine() {
		return immagine;
	}

	public int getCapienza() {
		return capienza;
	}

	public String toString() {
		String stampa;
		if (this.composito) {
			stampa = ("Tavolo Composito: " + this.idTavolo + " (" + this.capienza + ") - di seguito i tavoli componenti\n");
			Iterator<String> tci = listaComponenti.iterator();
			String id;
			while (tci.hasNext()) {
				id = tci.next();
				stampa += "   - " + id + "\n";				
			}	
		} else {
			stampa = (this.occupato ? "- " : "+ ");
			stampa += this.idTavolo + " - " + this.capienza + " - " + this.immagine;
		}
		return stampa;
	}

}
